/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.gpio.extension.pca;

import com.pi4j.gpio.extension.pca.PCA9685GpioProviderPinCache;
import com.pi4j.gpio.extension.pca.PCA9685Pin;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.GpioProviderBase;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.exception.InvalidPinException;
import com.pi4j.io.gpio.exception.InvalidPinModeException;
import com.pi4j.io.gpio.exception.ValidationException;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class PCA9685GpioProvider
extends GpioProviderBase
implements GpioProvider {
    public static final String NAME = "com.pi4j.gpio.extension.pca.PCA9685GpioProvider";
    public static final String DESCRIPTION = "PCA9685 PWM Provider";
    public static final int INTERNAL_CLOCK_FREQ = 25000000;
    public static final BigDecimal MIN_FREQUENCY = new BigDecimal("40");
    public static final BigDecimal MAX_FREQUENCY = new BigDecimal("1000");
    public static final BigDecimal ANALOG_SERVO_FREQUENCY = new BigDecimal("45.454");
    public static final BigDecimal DIGITAL_SERVO_FREQUENCY = new BigDecimal("90.909");
    public static final BigDecimal DEFAULT_FREQUENCY = ANALOG_SERVO_FREQUENCY;
    public static final int PWM_STEPS = 4096;
    private static final int PCA9685A_MODE1 = 0;
    private static final int PCA9685A_PRESCALE = 254;
    private static final int PCA9685A_LED0_ON_L = 6;
    private static final int PCA9685A_LED0_ON_H = 7;
    private static final int PCA9685A_LED0_OFF_L = 8;
    private static final int PCA9685A_LED0_OFF_H = 9;
    private boolean i2cBusOwner = false;
    private final I2CBus bus;
    private final I2CDevice device;
    private BigDecimal frequency;
    private int periodDurationMicros;
    protected PCA9685GpioProviderPinCache[] cache = new PCA9685GpioProviderPinCache[16];

    public PCA9685GpioProvider(int busNumber, int address) throws I2CFactory.UnsupportedBusNumberException, IOException {
        this(I2CFactory.getInstance(busNumber), address);
        this.i2cBusOwner = true;
    }

    public PCA9685GpioProvider(I2CBus bus, int address) throws IOException {
        this(bus, address, DEFAULT_FREQUENCY, BigDecimal.ONE);
    }

    public PCA9685GpioProvider(I2CBus bus, int address, BigDecimal targetFrequency) throws IOException {
        this(bus, address, targetFrequency, BigDecimal.ONE);
    }

    public PCA9685GpioProvider(I2CBus bus, int address, BigDecimal targetFrequency, BigDecimal frequencyCorrectionFactor) throws IOException {
        this.bus = bus;
        this.device = bus.getDevice(address);
        this.device.write(0, (byte)0);
        this.setFrequency(targetFrequency, frequencyCorrectionFactor);
    }

    public void setFrequency(BigDecimal frequency) {
        this.setFrequency(frequency, BigDecimal.ONE);
    }

    public void setFrequency(BigDecimal targetFrequency, BigDecimal frequencyCorrectionFactor) {
        this.validateFrequency(targetFrequency);
        this.frequency = targetFrequency;
        this.periodDurationMicros = this.calculatePeriodDuration();
        int prescale = this.calculatePrescale(frequencyCorrectionFactor);
        try {
            int oldMode = this.device.read(0);
            int newMode = oldMode & 0x7F | 0x10;
            this.device.write(0, (byte)newMode);
            this.device.write(254, (byte)prescale);
            this.device.write(0, (byte)oldMode);
            Thread.sleep(1L);
            this.device.write(0, (byte)(oldMode | 0x80));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to set prescale value [" + prescale + "]", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setPwm(Pin pin, int duration) {
        int offPosition = this.calculateOffPositionForPulseDuration(duration);
        this.setPwm(pin, 0, offPosition);
    }

    public void setPwm(Pin pin, int onPosition, int offPosition) {
        this.validatePin(pin, onPosition, offPosition);
        int channel = pin.getAddress();
        this.validatePwmValueInRange(onPosition);
        this.validatePwmValueInRange(offPosition);
        if (onPosition == offPosition) {
            throw new ValidationException("ON [" + onPosition + "] and OFF [" + offPosition + "] values must be different.");
        }
        try {
            this.device.write(6 + 4 * channel, (byte)(onPosition & 0xFF));
            this.device.write(7 + 4 * channel, (byte)(onPosition >> 8));
            this.device.write(8 + 4 * channel, (byte)(offPosition & 0xFF));
            this.device.write(9 + 4 * channel, (byte)(offPosition >> 8));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write to PWM channel [" + channel + "] values for ON [" + onPosition + "] and OFF [" + offPosition + "] position.", e);
        }
        this.cachePinValues(pin, onPosition, offPosition);
    }

    public void setAlwaysOn(Pin pin) {
        int pwmOnValue = 4096;
        boolean pwmOffValue = false;
        this.validatePin(pin, 4096, 0);
        int channel = pin.getAddress();
        try {
            this.device.write(6 + 4 * channel, (byte)0);
            this.device.write(7 + 4 * channel, (byte)16);
            this.device.write(8 + 4 * channel, (byte)0);
            this.device.write(9 + 4 * channel, (byte)0);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while trying to set channel [" + channel + "] always ON.", e);
        }
        this.cachePinValues(pin, 4096, 0);
    }

    public void setAlwaysOff(Pin pin) {
        boolean pwmOnValue = false;
        int pwmOffValue = 4096;
        this.validatePin(pin, 0, 4096);
        int channel = pin.getAddress();
        try {
            this.device.write(6 + 4 * channel, (byte)0);
            this.device.write(7 + 4 * channel, (byte)0);
            this.device.write(8 + 4 * channel, (byte)0);
            this.device.write(9 + 4 * channel, (byte)16);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while trying to set channel [" + channel + "] always OFF.", e);
        }
        this.cachePinValues(pin, 0, 4096);
    }

    public BigDecimal getFrequency() {
        return this.frequency;
    }

    public int getPeriodDurationMicros() {
        return this.periodDurationMicros;
    }

    public int calculateOffPositionForPulseDuration(int duration) {
        this.validatePwmDuration(duration);
        int result = 4095 * duration / this.periodDurationMicros;
        if (result < 1) {
            result = 1;
        } else if (result > 4095) {
            result = 4095;
        }
        return result;
    }

    private int calculatePeriodDuration() {
        return new BigDecimal("1000000").divide(this.frequency, 0, RoundingMode.HALF_UP).intValue();
    }

    private int calculatePrescale(BigDecimal frequencyCorrectionFactor) {
        BigDecimal theoreticalPrescale = BigDecimal.valueOf(25000000L);
        theoreticalPrescale = theoreticalPrescale.divide(BigDecimal.valueOf(4096L), 3, RoundingMode.HALF_UP);
        theoreticalPrescale = theoreticalPrescale.divide(this.frequency, 0, RoundingMode.HALF_UP);
        theoreticalPrescale = theoreticalPrescale.subtract(BigDecimal.ONE);
        return theoreticalPrescale.multiply(frequencyCorrectionFactor).intValue();
    }

    private void validateFrequency(BigDecimal frequency) {
        if (frequency.compareTo(MIN_FREQUENCY) == -1 || frequency.compareTo(MAX_FREQUENCY) == 1) {
            throw new ValidationException("Frequency [" + frequency + "] must be between 40.0 and 1000.0 Hz.");
        }
    }

    private void validatePwmValueInRange(int pwmValue) {
        if (pwmValue < 0 || pwmValue > 4095) {
            throw new ValidationException("PWM position value [" + pwmValue + "] must be between 0 and 4095.");
        }
    }

    private void validatePwmDuration(int duration) {
        if (duration < 1) {
            throw new ValidationException("Duration [" + duration + "] must be >= 1us.");
        }
        if (duration >= this.periodDurationMicros) {
            throw new ValidationException("Duration [" + duration + "] must be <= period duration [" + this.periodDurationMicros + "].");
        }
    }

    private void validatePin(Pin pin, int onPosition, int offPosition) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        PinMode mode = this.getMode(pin);
        if (mode != PinMode.PWM_OUTPUT) {
            throw new InvalidPinModeException(pin, "Invalid pin mode [" + mode.getName() + "]; unable to setPwm(" + onPosition + ", " + offPosition + ")");
        }
    }

    private void cachePinValues(Pin pin, int onPosition, int offPosition) {
        this.getPinCache(pin).setPwmOnValue(onPosition);
        this.getPinCache(pin).setPwmOffValue(offPosition);
    }

    public int[] getPwmOnOffValues(Pin pin) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        int[] pwmValues = new int[]{this.getPinCache(pin).getPwmOnValue(), this.getPinCache(pin).getPwmOffValue()};
        return pwmValues;
    }

    public void reset() {
        for (Pin pin : PCA9685Pin.ALL) {
            this.setAlwaysOff(pin);
        }
    }

    @Override
    protected PCA9685GpioProviderPinCache getPinCache(Pin pin) {
        PCA9685GpioProviderPinCache pc = this.cache[pin.getAddress()];
        if (pc == null) {
            PCA9685GpioProviderPinCache pCA9685GpioProviderPinCache = new PCA9685GpioProviderPinCache(pin);
            this.cache[pin.getAddress()] = pCA9685GpioProviderPinCache;
            pc = pCA9685GpioProviderPinCache;
        }
        return pc;
    }

    @Override
    public int getPwm(Pin pin) {
        throw new UnsupportedOperationException("Use getPwmOnOffValues() instead.");
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void shutdown() {
        if (this.isShutdown()) {
            return;
        }
        super.shutdown();
        this.reset();
        try {
            if (this.i2cBusOwner) {
                this.bus.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

