/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.nws.lub.rainpi2;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;

public class HardwareInterface {
    protected static final long mDebounceIntervalMs = 250L;
    protected long mDebouncetime;
    private OnHardwareClickListener mListener;

    public void setOnHardwareClickListner(OnHardwareClickListener listen) {
        System.out.println("Set Hardware Listener");
        this.mListener = listen;
    }

    public void start() {
        assert (this.mListener == null);
        GpioController gpio = GpioFactory.getInstance();
        GpioPinDigitalInput iopin = gpio.provisionDigitalInputPin(RaspiPin.GPIO_07, PinPullResistance.PULL_UP);
        iopin.addListener(new GpioPinListenerDigital(){

            @Override
            public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
                long timesincelastclick = System.currentTimeMillis() - HardwareInterface.this.mDebouncetime;
                System.out.println(" --> GPIO PIN STATE CHANGE: " + event.getPin() + " = " + (Object)((Object)event.getState()));
                if (event.getState() == PinState.HIGH) {
                    if (timesincelastclick > 250L) {
                        if (HardwareInterface.this.mListener != null) {
                            HardwareInterface.this.mListener.onTip();
                        }
                        HardwareInterface.this.mDebouncetime = System.currentTimeMillis();
                    } else {
                        System.out.println("Unrealistic PRECIP rate - DeltaT=" + timesincelastclick);
                    }
                }
            }
        });
    }

    public static interface OnHardwareClickListener {
        public void onTip();
    }
}

