/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.nws.lub.rainpi2;

import gov.noaa.nws.lub.rainpi2.Constants;
import gov.noaa.nws.lub.rainpi2.RainPi2;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;

public class ProcessUpdate {
    private static final String mFilename = "updateRainPi";
    private static final String mFilenameStartup = "startRainPi";

    public ProcessUpdate() {
        System.out.println("Performing Process Update");
        this.updatePackage();
        this.restartProgram();
    }

    private void updatePackage() {
        System.out.println("Updating package");
        File currentJar = null;
        try {
            currentJar = new File(RainPi2.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        String fpath = currentJar.getAbsolutePath();
        String fname = currentJar.getName();
        String pwd = fpath.substring(0, fpath.indexOf(fname));
        this.generateUpdateScript();
        ArrayList<String> command = new ArrayList<String>();
        command.add("sh");
        command.add(String.valueOf(pwd) + mFilename);
        System.out.println("Run Script at " + pwd + mFilename);
        ProcessBuilder builder = new ProcessBuilder(command);
        try {
            builder.start();
            System.out.println("Script executed");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateUpdateScript() {
        String url = "http://" + Constants.mServerIp + ":" + Constants.mServerPort + "/rainpi.jar";
        File currentJar = null;
        String javaBin = String.valueOf(System.getProperty("java.home")) + File.separator + "bin" + File.separator + "java";
        try {
            currentJar = new File(RainPi2.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (currentJar == null) {
            System.err.println("Unable to determine the currently running jar file");
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(mFilename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            writer.write("#!/bin/bash");
            writer.newLine();
            writer.write("echo 'Sleeping 5'");
            writer.newLine();
            writer.write("sleep 5s");
            writer.newLine();
            writer.write("echo 'Downloading'");
            writer.newLine();
            writer.write("wget -q " + url + " -O " + currentJar.getPath() + " --timestamping");
            writer.newLine();
            writer.write("echo 'Downloaded...now starting'");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("chmod");
        command.add("a+x");
        command.add(mFilename);
        ProcessBuilder builder = new ProcessBuilder(command);
        try {
            builder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void restartProgram() {
        System.out.println("Restarting program");
        File currentJar = null;
        String javaBin = String.valueOf(System.getProperty("java.home")) + File.separator + "bin" + File.separator + "java";
        System.out.println("JAVA binary " + javaBin);
        try {
            currentJar = new File(RainPi2.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            System.out.println("To run:  " + currentJar.getPath());
            if (!currentJar.getName().endsWith(".jar")) {
                System.err.println("Unable to find jar file! ");
                return;
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add(javaBin);
            command.add("-jar");
            command.add(currentJar.getPath());
            ProcessBuilder builder = new ProcessBuilder(command);
            try {
                System.out.println("Restarting in ");
                int i = 30;
                while (i > 0) {
                    Thread.sleep(1000L);
                    System.out.print(".." + i);
                    --i;
                }
                builder.start();
                System.exit(0);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

