/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.nws.lub.rainpi2;

import gov.noaa.nws.lub.rainpi2.Constants;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;

public class URLConnectionReader {
    private onResponseListener mListener;

    public void setResponseListener(onResponseListener listener) {
        this.mListener = listener;
    }

    public void getText(String url, String postString) {
        if (this.mListener == null) {
            System.err.println("You need to specify a listener before you can launch a URL query");
        }
        StringBuilder response = new StringBuilder();
        try {
            String inputLine;
            int responseCode;
            URL website = new URL(url);
            HttpURLConnection con = (HttpURLConnection)website.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", Constants.mUserAgent);
            con.setRequestProperty("Accept-Language", "en-US,en);q=0.5");
            if (postString != null) {
                con.setRequestMethod("POST");
                con.setDoOutput(true);
                DataOutputStream wr = new DataOutputStream(con.getOutputStream());
                wr.writeBytes(postString);
                wr.flush();
                wr.close();
            }
            if ((responseCode = con.getResponseCode()) != 200) {
                System.err.println("Invalid response code " + responseCode);
                return;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
        }
        catch (ConnectException e) {
            System.err.println("Connect Exception " + url);
            return;
        }
        catch (IOException e) {
            System.err.println("IOException Exception " + url);
            return;
        }
        if (this.mListener != null) {
            this.mListener.response(response.toString());
        }
    }

    public static interface onResponseListener {
        public void response(String var1);
    }
}

