/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.gpio.extension.mcp;

import com.pi4j.gpio.extension.mcp.MCP23017Pin;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.GpioProviderBase;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.PinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.PinListener;
import com.pi4j.io.gpio.exception.InvalidPinException;
import com.pi4j.io.gpio.exception.UnsupportedPinPullResistanceException;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;
import java.util.List;

public class MCP23017GpioProvider
extends GpioProviderBase
implements GpioProvider {
    public static final String NAME = "com.pi4j.gpio.extension.mcp.MCP23017GpioProvider";
    public static final String DESCRIPTION = "MCP23017 GPIO Provider";
    public static final int DEFAULT_ADDRESS = 32;
    public static final int DEFAULT_POLLING_TIME = 50;
    private static final int REGISTER_IODIR_A = 0;
    private static final int REGISTER_IODIR_B = 1;
    private static final int REGISTER_GPINTEN_A = 4;
    private static final int REGISTER_GPINTEN_B = 5;
    private static final int REGISTER_DEFVAL_A = 6;
    private static final int REGISTER_DEFVAL_B = 7;
    private static final int REGISTER_INTCON_A = 8;
    private static final int REGISTER_INTCON_B = 9;
    private static final int REGISTER_GPPU_A = 12;
    private static final int REGISTER_GPPU_B = 13;
    private static final int REGISTER_INTF_A = 14;
    private static final int REGISTER_INTF_B = 15;
    private static final int REGISTER_GPIO_A = 18;
    private static final int REGISTER_GPIO_B = 19;
    private static final int GPIO_A_OFFSET = 0;
    private static final int GPIO_B_OFFSET = 1000;
    private int currentStatesA = 0;
    private int currentStatesB = 0;
    private int currentDirectionA = 0;
    private int currentDirectionB = 0;
    private int currentPullupA = 0;
    private int currentPullupB = 0;
    private int pollingTime = 50;
    private boolean i2cBusOwner = false;
    private final I2CBus bus;
    private final I2CDevice device;
    private GpioStateMonitor monitor = null;

    public MCP23017GpioProvider(int busNumber, int address) throws I2CFactory.UnsupportedBusNumberException, IOException {
        this(busNumber, address, 50);
    }

    public MCP23017GpioProvider(int busNumber, int address, int pollingTime) throws IOException, I2CFactory.UnsupportedBusNumberException {
        this(I2CFactory.getInstance(busNumber), address, pollingTime);
    }

    public MCP23017GpioProvider(I2CBus bus, int address) throws IOException {
        this(bus, address, 50);
    }

    public MCP23017GpioProvider(I2CBus bus, int address, int pollingTime) throws IOException {
        this.bus = bus;
        this.device = bus.getDevice(address);
        this.currentStatesA = this.device.read(18);
        this.currentStatesB = this.device.read(19);
        this.device.write(0, (byte)this.currentDirectionA);
        this.device.write(1, (byte)this.currentDirectionB);
        this.device.write(4, (byte)this.currentDirectionA);
        this.device.write(5, (byte)this.currentDirectionB);
        this.device.write(6, (byte)0);
        this.device.write(7, (byte)0);
        this.device.write(8, (byte)0);
        this.device.write(9, (byte)0);
        this.device.write(18, (byte)this.currentStatesA);
        this.device.write(19, (byte)this.currentStatesB);
        this.device.write(12, (byte)this.currentPullupA);
        this.device.write(13, (byte)this.currentPullupB);
        this.pollingTime = pollingTime;
        this.i2cBusOwner = true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void export(Pin pin, PinMode mode) {
        super.export(pin, mode);
        this.setMode(pin, mode);
    }

    @Override
    public void unexport(Pin pin) {
        super.unexport(pin);
        this.setMode(pin, PinMode.DIGITAL_OUTPUT);
    }

    @Override
    public void setMode(Pin pin, PinMode mode) {
        super.setMode(pin, mode);
        try {
            if (pin.getAddress() < 1000) {
                this.setModeA(pin, mode);
            } else {
                this.setModeB(pin, mode);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (this.currentDirectionA > 0 || this.currentDirectionB > 0) {
            if (this.monitor == null) {
                this.monitor = new GpioStateMonitor(this.device);
                this.monitor.start();
            }
        } else if (this.monitor != null) {
            this.monitor.shutdown();
            this.monitor = null;
        }
    }

    private void setModeA(Pin pin, PinMode mode) throws IOException {
        int pinAddress = pin.getAddress() - 0;
        if (mode == PinMode.DIGITAL_INPUT) {
            this.currentDirectionA |= pinAddress;
        } else if (mode == PinMode.DIGITAL_OUTPUT) {
            this.currentDirectionA &= ~pinAddress;
        }
        this.device.write(0, (byte)this.currentDirectionA);
        this.device.write(4, (byte)this.currentDirectionA);
    }

    private void setModeB(Pin pin, PinMode mode) throws IOException {
        int pinAddress = pin.getAddress() - 1000;
        if (mode == PinMode.DIGITAL_INPUT) {
            this.currentDirectionB |= pinAddress;
        } else if (mode == PinMode.DIGITAL_OUTPUT) {
            this.currentDirectionB &= ~pinAddress;
        }
        this.device.write(1, (byte)this.currentDirectionB);
        this.device.write(5, (byte)this.currentDirectionB);
    }

    @Override
    public PinMode getMode(Pin pin) {
        return super.getMode(pin);
    }

    @Override
    public void setState(Pin pin, PinState state) {
        super.setState(pin, state);
        try {
            if (pin.getAddress() < 1000) {
                this.setStateA(pin, state);
            } else {
                this.setStateB(pin, state);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void setStateA(Pin pin, PinState state) throws IOException {
        int pinAddress = pin.getAddress() - 0;
        this.currentStatesA = state.isHigh() ? (this.currentStatesA |= pinAddress) : (this.currentStatesA &= ~pinAddress);
        this.device.write(18, (byte)this.currentStatesA);
    }

    private void setStateB(Pin pin, PinState state) throws IOException {
        int pinAddress = pin.getAddress() - 1000;
        this.currentStatesB = state.isHigh() ? (this.currentStatesB |= pinAddress) : (this.currentStatesB &= ~pinAddress);
        this.device.write(19, (byte)this.currentStatesB);
    }

    @Override
    public PinState getState(Pin pin) {
        PinState result = super.getState(pin);
        result = pin.getAddress() < 1000 ? this.getStateA(pin) : this.getStateB(pin);
        return result;
    }

    private PinState getStateA(Pin pin) {
        int pinAddress = pin.getAddress() - 0;
        PinState state = (this.currentStatesA & pinAddress) == pinAddress ? PinState.HIGH : PinState.LOW;
        this.getPinCache(pin).setState(state);
        return state;
    }

    private PinState getStateB(Pin pin) {
        int pinAddress = pin.getAddress() - 1000;
        PinState state = (this.currentStatesB & pinAddress) == pinAddress ? PinState.HIGH : PinState.LOW;
        this.getPinCache(pin).setState(state);
        return state;
    }

    @Override
    public void setPullResistance(Pin pin, PinPullResistance resistance) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        if (!pin.getSupportedPinPullResistance().contains((Object)resistance)) {
            throw new UnsupportedPinPullResistanceException(pin, resistance);
        }
        try {
            if (pin.getAddress() < 1000) {
                this.setPullResistanceA(pin, resistance);
            } else {
                this.setPullResistanceB(pin, resistance);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.getPinCache(pin).setResistance(resistance);
    }

    private void setPullResistanceA(Pin pin, PinPullResistance resistance) throws IOException {
        int pinAddress = pin.getAddress() - 0;
        this.currentPullupA = resistance == PinPullResistance.PULL_UP ? (this.currentPullupA |= pinAddress) : (this.currentPullupA &= ~pinAddress);
        this.device.write(12, (byte)this.currentPullupA);
    }

    private void setPullResistanceB(Pin pin, PinPullResistance resistance) throws IOException {
        int pinAddress = pin.getAddress() - 1000;
        this.currentPullupB = resistance == PinPullResistance.PULL_UP ? (this.currentPullupB |= pinAddress) : (this.currentPullupB &= ~pinAddress);
        this.device.write(13, (byte)this.currentPullupB);
    }

    @Override
    public PinPullResistance getPullResistance(Pin pin) {
        return super.getPullResistance(pin);
    }

    @Override
    public void shutdown() {
        if (this.isShutdown()) {
            return;
        }
        super.shutdown();
        try {
            if (this.monitor != null) {
                this.monitor.shutdown();
                this.monitor = null;
            }
            if (this.i2cBusOwner) {
                this.bus.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPollingTime(int pollingTime) {
        this.pollingTime = pollingTime;
    }

    private class GpioStateMonitor
    extends Thread {
        private final I2CDevice device;
        private boolean shuttingDown = false;

        public GpioStateMonitor(I2CDevice device) {
            this.device = device;
        }

        public void shutdown() {
            this.shuttingDown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (!this.shuttingDown) {
                try {
                    int pinInterruptB;
                    int pinInterruptState;
                    int pinInterruptA;
                    Class<MCP23017GpioProvider> clazz = MCP23017GpioProvider.class;
                    // MONITORENTER : com.pi4j.gpio.extension.mcp.MCP23017GpioProvider.class
                    if (MCP23017GpioProvider.this.currentDirectionA > 0 && (pinInterruptA = this.device.read(14)) > 0) {
                        pinInterruptState = this.device.read(18);
                        for (Pin pin : MCP23017Pin.ALL_A_PINS) {
                            this.evaluatePinForChangeA(pin, pinInterruptState);
                        }
                    }
                    if (MCP23017GpioProvider.this.currentDirectionB > 0 && (pinInterruptB = this.device.read(15)) > 0) {
                        pinInterruptState = this.device.read(19);
                        for (Pin pin : MCP23017Pin.ALL_B_PINS) {
                            this.evaluatePinForChangeB(pin, pinInterruptState);
                        }
                    }
                    // MONITOREXIT : clazz
                    Thread.currentThread();
                    Thread.sleep(MCP23017GpioProvider.this.pollingTime);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void evaluatePinForChangeA(Pin pin, int state) {
            int pinAddress;
            if (MCP23017GpioProvider.this.getPinCache(pin).isExported() && (state & (pinAddress = pin.getAddress() - 0)) != (MCP23017GpioProvider.this.currentStatesA & pinAddress)) {
                PinState newState = (state & pinAddress) == pinAddress ? PinState.HIGH : PinState.LOW;
                MCP23017GpioProvider.this.getPinCache(pin).setState(newState);
                if (newState.isHigh()) {
                    MCP23017GpioProvider.this.currentStatesA = MCP23017GpioProvider.this.currentStatesA | pinAddress;
                } else {
                    MCP23017GpioProvider.this.currentStatesA = MCP23017GpioProvider.this.currentStatesA & ~pinAddress;
                }
                this.dispatchPinChangeEvent(pin.getAddress(), newState);
            }
        }

        private void evaluatePinForChangeB(Pin pin, int state) {
            int pinAddress;
            if (MCP23017GpioProvider.this.getPinCache(pin).isExported() && (state & (pinAddress = pin.getAddress() - 1000)) != (MCP23017GpioProvider.this.currentStatesB & pinAddress)) {
                PinState newState = (state & pinAddress) == pinAddress ? PinState.HIGH : PinState.LOW;
                MCP23017GpioProvider.this.getPinCache(pin).setState(newState);
                if (newState.isHigh()) {
                    MCP23017GpioProvider.this.currentStatesB = MCP23017GpioProvider.this.currentStatesB | pinAddress;
                } else {
                    MCP23017GpioProvider.this.currentStatesB = MCP23017GpioProvider.this.currentStatesB & ~pinAddress;
                }
                this.dispatchPinChangeEvent(pin.getAddress(), newState);
            }
        }

        private void dispatchPinChangeEvent(int pinAddress, PinState state) {
            for (Pin pin : MCP23017GpioProvider.this.listeners.keySet()) {
                if (pin.getAddress() != pinAddress) continue;
                for (PinListener listener : (List)MCP23017GpioProvider.this.listeners.get(pin)) {
                    listener.handlePinEvent(new PinDigitalStateChangeEvent((Object)this, pin, state));
                }
            }
        }
    }
}

