/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.gpio.extension.mcp;

import com.pi4j.gpio.extension.base.DacGpioProvider;
import com.pi4j.gpio.extension.base.DacGpioProviderBase;
import com.pi4j.gpio.extension.mcp.MCP4725Pin;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;

public class MCP4725GpioProvider
extends DacGpioProviderBase
implements DacGpioProvider {
    public static final String NAME = "com.pi4j.gpio.extension.mcp.MCP4725GpioProvider";
    public static final String DESCRIPTION = "MCP4725 GPIO Provider";
    private boolean i2cBusOwner = false;
    private final I2CBus bus;
    private final I2CDevice device;
    public static final int MAX_VALUE = 4095;
    public static final int MIN_VALUE = 0;
    public static final int MCP4725_ADDRESS_1 = 98;
    public static final int MCP4725_ADDRESS_2 = 99;
    private static final int MCP4725_REG_WRITEDAC = 64;
    private static final int MCP4725_REG_WRITEDAC_EEPROM = 96;

    public MCP4725GpioProvider(int busNumber, int address) throws I2CFactory.UnsupportedBusNumberException, IOException {
        this(I2CFactory.getInstance(busNumber), address);
        this.i2cBusOwner = true;
    }

    public MCP4725GpioProvider(I2CBus bus, int address) throws IOException {
        super(MCP4725Pin.ALL);
        this.bus = bus;
        this.device = bus.getDevice(address);
    }

    @Override
    public void setValue(Pin pin, double value) {
        if (value <= this.getMinSupportedValue()) {
            value = this.getMinSupportedValue();
        } else if (value >= this.getMaxSupportedValue()) {
            value = this.getMaxSupportedValue();
        }
        int write_value = (int)value;
        try {
            byte[] packet = new byte[]{64, (byte)(write_value >> 4), (byte)(write_value << 4)};
            this.device.write(packet, 0, 3);
            super.setValue(pin, value);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write DAC output value.", e);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void shutdown() {
        if (this.isShutdown()) {
            return;
        }
        super.shutdown();
        try {
            if (this.i2cBusOwner) {
                this.bus.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double getMinSupportedValue() {
        return 0.0;
    }

    @Override
    public double getMaxSupportedValue() {
        return 4095.0;
    }
}

